<?php


namespace App\Mail;

use App\Models\Courier;
use App\Models\CourierUpdate;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CourierUpdated extends Mailable
{
    use Queueable, SerializesModels;

    public $courier;
    public $update;

    public function __construct(Courier $courier, CourierUpdate $update)
    {
        $this->courier = $courier;
        $this->update = $update;
    }

    public function build()
    {
        return $this->subject('Shipment Update – ' . $this->courier->tracking_code)
                    ->markdown('emails.couriers.updated');
    }
}
