<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouriersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('couriers', function (Blueprint $table) {
    $table->id();
    $table->string('tracking_code')->unique();

    // Sender info
    $table->string('sender_name');
    $table->string('sender_email');
    $table->text('sender_address');

    // Receiver info
    $table->string('receiver_name');
    $table->string('receiver_email');
    $table->string('receiver_contact');
    $table->text('receiver_address');

    // Package info
    $table->boolean('delivery_completion')->default(false);
    $table->text('description')->nullable();
    $table->integer('quantity')->default(1);
    $table->decimal('weight', 10, 2)->nullable();
    $table->string('status')->default('Pending');
    $table->string('shipment_progress')->nullable();

    // Location & delivery
    $table->string('origin');
    $table->string('current_location')->nullable();
    $table->string('destination');
    $table->decimal('freight_cost', 10, 2)->nullable();
    $table->date('estimated_delivery')->nullable();
    $table->date('dispatch_date')->nullable();

    // Package image
    $table->string('photo')->nullable();

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('couriers');
    }
}
