@extends('layouts.base')
@inject('content', 'App\Http\Controllers\FrontController')
@section('content')



    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Hero Section -->
<section class="relative h-screen flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-horizon-900/90 to-horizon-700/70 z-10"></div>
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="Logistics Operations"
             class="w-full h-full object-cover">
    </div>

    <div class="relative z-20 text-center text-white px-4 sm:px-6 lg:px-8">
        <h1 class="font-display text-4xl md:text-6xl lg:text-7xl font-bold mb-6 animate-slide-up">
            Transport & <br>
            <span class="text-gold-400">Logistics</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto animate-slide-up" style="animation-delay: 0.2s;">
            Take the complexity out of customs Freight Solutions <br>
            with customs brokerage services
        </p>
        <a href="services"
           class="inline-flex items-center px-8 py-4 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-all duration-300 transform hover:scale-105 animate-slide-up"
           style="animation-delay: 0.4s;">
            DISCOVER OUR SERVICES
            <i class="fas fa-arrow-right ml-2"></i>
        </a>
    </div>
</section>

<!-- Main Content Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-shipping-fast text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-6">
                Reliable UK & Ireland Transport<br>
                <span class="text-gold-600">Logistics Since 1973</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
            <!-- Content Column -->
            <div class="space-y-6">
                <p class="text-lg text-secondary-600 leading-relaxed">
                    Because we understand that your top priority is to get your goods to your customers on time and in full, we offer a full spectrum of transport logistics solutions to ensure you have the flexibility to send different sizes of consignment without having to find a new provider.
                </p>
                <p class="text-lg text-secondary-600 leading-relaxed">
                    With so many options available you can rest assured that we will be able to deliver your consignment, regardless of its size. And if there's ever a time where you need some advice on choosing the right solution, our transport team, who have more than 120 years' experience.
                </p>

                <!-- Statistics -->
                <div class="grid grid-cols-2 gap-6 mt-8">
                    <div class="text-center p-6 bg-horizon-50 rounded-lg">
                        <div class="text-3xl font-bold text-horizon-700 mb-2">50+</div>
                        <div class="text-sm text-secondary-600">Years Experience</div>
                    </div>
                    <div class="text-center p-6 bg-gold-50 rounded-lg">
                        <div class="text-3xl font-bold text-gold-600 mb-2">120+</div>
                        <div class="text-sm text-secondary-600">Expert Team</div>
                    </div>
                </div>

                <div class="mt-8">
                    <img src="https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Warehouse Operations"
                         class="w-full h-64 object-cover rounded-lg shadow-soft">
                </div>
            </div>

            <!-- Images Column -->
            <div class="space-y-6">
                <img src="https://images.unsplash.com/photo-1494412574643-ff11b0a5c1c3?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Logistics Team"
                     class="w-full h-80 object-cover rounded-lg shadow-soft">
                <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Transport Fleet"
                     class="w-full h-64 object-cover rounded-lg shadow-soft">
            </div>
        </div>
    </div>
</section>

<!-- Services List Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Services List -->
            <div>
                <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-8">
                    {{$settings->site_name}} <br>
                    <span class="text-gold-600">Services Include:</span>
                </h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-4">
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-horizon-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Contract distribution</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-horizon-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Ad-hoc transport</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-horizon-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Groupage</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-horizon-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Tail-lift deliveries</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-horizon-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Double-deck trailers</span>
                        </div>
                    </div>

                    <div class="space-y-4">
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Reverse logistics</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Curtain-sided vehicles</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Next day delivery</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">Timed deliveries</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="flex-shrink-0 w-6 h-6 bg-gold-600 rounded-full flex items-center justify-center">
                                <i class="fas fa-check text-white text-xs"></i>
                            </div>
                            <span class="text-secondary-700 font-medium">AM deliveries</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Image -->
            <div>
                <img src="https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Logistics Services"
                     class="w-full h-96 object-cover rounded-lg shadow-soft">
            </div>
        </div>
    </div>
</section>

<!-- Contact CTA Section -->
<section class="py-16 lg:py-24 bg-gradient-to-r from-horizon-700 to-horizon-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold mb-6">
            Contact us today!
        </h2>
        <p class="text-xl md:text-2xl mb-8 text-gray-200">
            Contact us today for your airfreight <br>
            requirements
        </p>
        <a href="contact"
           class="inline-flex items-center px-8 py-4 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-all duration-300 transform hover:scale-105">
            CLICK HERE TO CONTACT US!
            <i class="fas fa-arrow-right ml-2"></i>
        </a>
    </div>
</section>

<!-- Service Highlights Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Service 1 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Full Load Services"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        Full, Part, and <br>
                        Consolidated Loads
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Our dedicated fleet of vehicles operates nationally throughout the UK delivering both full, part, and consolidated loads.
                    </p>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Palletforce Equipment"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        Palletforce <br>
                        Equipment
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Sending smaller consignments of less than 10 pallets used to be expensive business, but we have a solution for you.
                    </p>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="European Transport"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">
                        European Transport <br>
                        Logistics
                    </h3>
                    <p class="text-secondary-600 leading-relaxed">
                        In addition to our UK services, through our trusted and fully-vetted network of partners, we offer a full import and export service.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Additional CTA Section -->
<section class="py-16 bg-gradient-to-br from-gold-50 to-horizon-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-soft p-8 md:p-12 text-center">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-r from-horizon-600 to-gold-600 rounded-full mb-6">
                <i class="fas fa-truck text-2xl text-white"></i>
            </div>
            <h2 class="font-display text-2xl md:text-3xl font-bold text-horizon-800 mb-4">
                Ready to Ship with {{$settings->site_name}}?
            </h2>
            <p class="text-lg text-secondary-600 mb-8 max-w-2xl mx-auto">
                Get started with our comprehensive logistics solutions today. Our expert team is ready to handle your shipping needs with precision and care.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="#"
                   class="inline-flex items-center justify-center px-8 py-3 bg-horizon-700 hover:bg-horizon-800 text-white font-semibold rounded-lg transition-colors duration-200">
                    Get Quote
                    <i class="fas fa-calculator ml-2"></i>
                </a>
                <a href="track"
                   class="inline-flex items-center justify-center px-8 py-3 border-2 border-gold-500 text-gold-600 hover:bg-gold-500 hover:text-white font-semibold rounded-lg transition-colors duration-200">
                    Track Shipment
                    <i class="fas fa-search ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>
        </div>
    </main>



@endsection
